import serial
import sys
import time

if __name__ == '__main__':

    import argparse

    parser = argparse.ArgumentParser(
        description='CAN tester for SoMLabs boards')

    parser.add_argument(
        '-p', '--port',
        help='serial port name')

    args = parser.parse_args()
    canPort = serial.Serial()
    canPort.port = args.port
    canPort.baudrate = 115200


    try:
        canPort.open()
    except serial.SerialException as e:
        sys.stderr.write(
            'Could not open serial port {}: {}\n'.format(canPort.name, e))
        sys.exit(1)

    canPort.write(b'S4\r')
    canPort.write(b'O\r')

    line = ''
    print('Waiting for CAN frames')
    while True:
        line += canPort.read(1).decode().strip()
        #break
        if 't1233123456' in line:
            line = ''
            print("Frame received, sending response.")
            time.sleep(0.5)
            canPort.write(b't1233123456\r\n')
