import serial
import sys
import time

if __name__ == '__main__':

    import argparse

    parser = argparse.ArgumentParser(
        description='RS485 port tester for SoMLabs boards')

    parser.add_argument(
        '-p', '--port',
        help='serial port name')

    args = parser.parse_args()
    rsPort = serial.Serial()
    rsPort.port = args.port
    rsPort.baudrate = 9600


    try:
        rsPort.open()
    except serial.SerialException as e:
        sys.stderr.write(
            'Could not open serial port {}: {}\n'.format(rsPort.name, e))
        sys.exit(1)

    print('Waiting for RS485 frames')
    while True:
        line = rsPort.readline().decode().strip()
        if '12 34 56' in line:
            print("Frame received, sending response.")
            time.sleep(0.5)
            resp = b'12 34 56\n\0'
            rsPort.write(resp)
