/*
 * usbTask.c
 *
 *  Created on: Feb 12, 2025
 *      Author: krzysiek
 */

#include "usbTask.h"
#include "guiTask.h"
#include "test.h"

#include "usb_host.h"
#include "usbh_core.h"
#include "usbh_msc.h"

osThreadId_t usbTaskHandle;

const osThreadAttr_t usbTask_attributes = {
  .name = "usbTask",
  .stack_size = 512 * 4,
  .priority = (osPriority_t) osPriorityLow,
};


extern USBH_HandleTypeDef hUsbHostHS;
extern USBH_HandleTypeDef hUsbHostFS;

int testReported[2];
UsbEvent_t usbEvent[2];

static void usbProcess(USBH_HandleTypeDef *phost, uint8_t id)
{
    uint8_t usbId;
    if(phost == &hUsbHostHS)
        usbId = 0;
    else if(phost == &hUsbHostFS)
        usbId = 1;
    else
        return;

    if(id == HOST_USER_CLASS_ACTIVE)
    {
        usbEvent[usbId].active = 1;
        usbEvent[usbId].type = UsbEventType_Attached;
        usbEvent[usbId].vid = phost->device.DevDesc.idVendor;
        usbEvent[usbId].pid = phost->device.DevDesc.idProduct;
    } else if (id == HOST_USER_DISCONNECTION) {
        usbEvent[usbId].active = 1;
        usbEvent[usbId].type = UsbEventType_Detached;
        usbEvent[usbId].vid = 0;
        usbEvent[usbId].pid = 0;
    }
}

void usbTask(void *pvParameters) {
    int usbId = (int)pvParameters;

    testReported[usbId] = 0;

    if(usbId == 0) {
        if (USBH_Init(&hUsbHostHS, usbProcess, HOST_HS) != USBH_OK)
            Error_Handler();
        if (USBH_RegisterClass(&hUsbHostHS, USBH_MSC_CLASS) != USBH_OK)
            Error_Handler();
        if (USBH_Start(&hUsbHostHS) != USBH_OK)
            Error_Handler();
    }

    else if(usbId == 1) {
        if (USBH_Init(&hUsbHostFS, usbProcess, HOST_FS) != USBH_OK)
            Error_Handler();
        if (USBH_RegisterClass(&hUsbHostFS, USBH_MSC_CLASS) != USBH_OK)
            Error_Handler();
        if (USBH_Start(&hUsbHostFS) != USBH_OK)
            Error_Handler();
    }

    while(1) {
        vTaskDelay(100 / portTICK_PERIOD_MS);

        if(usbEvent[usbId].active == 1) {
            usbEvent[usbId].active = 0;
            GuiEvent_t event;
            if(usbEvent[usbId].type == UsbEventType_Attached) {
                if(!testReported[usbId]) {
                    testReported[usbId] = 1;
                    event.type = GuiEventType_Test;
                    if(usbId == 0)
                        event.data[0] = TestType_Usb1;
                    else
                        event.data[0] = TestType_Usb2;
                    event.data[1] = TestResult_OK;
                    osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
                }

                event.type = GuiEventType_Usb;
                event.data[0] = usbId;
                event.data[1] = usbEvent[usbId].type;
                event.data[2] = usbEvent[usbId].vid;
                event.data[3] = usbEvent[usbId].pid;
                osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
            } else if(usbEvent[usbId].type == UsbEventType_Detached) {
                event.type = GuiEventType_Usb;
                event.data[0] = usbId;
                event.data[1] = usbEvent[usbId].type;
                event.data[2] = 0;
                event.data[3] = 0;
                osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
            }
        }
    }
}
