/*
 * sdTask.c
 *
 *  Created on: Jan 27, 2025
 *      Author: krzysiek
 */

#include <stdbool.h>
#include <string.h>
#include "sdTask.h"
#include "guiTask.h"
#include "test.h"
#include "fatfs.h"

osThreadId_t sdTaskHandle;
char fileBytesBuffer[10] = {0};
FIL fileObject;

const osThreadAttr_t sdTask_attributes = {
  .name = "sdTask",
  .stack_size = 512 * 4,
  .priority = (osPriority_t) osPriorityLow,
};

void sdTask(void *argument)
{
    SCB_DisableDCache();
    HAL_GPIO_WritePin(WIFI_WL_REG_ON_GPIO_Port, WIFI_WL_REG_ON_Pin, GPIO_PIN_RESET);

    GuiEvent_t event;
    event.type = GuiEventType_Test;
    event.data[0] = TestType_Sd;
    event.data[1] = TestResult_OK;

    if(f_mount(&SDFatFS, "", 1) != FR_OK) {
        printf("SD mount FAILED\r\n");
        event.data[1] = TestResult_Failed;
        osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
        SCB_EnableDCache();
        osThreadExit();
    }

    if(f_open(&fileObject, "0:/testfile.txt", FA_READ) != FR_OK) {
        printf("SD file open FAILED\r\n");
        event.data[1] = TestResult_Failed;
        osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
        SCB_EnableDCache();
        osThreadExit();
    }

    UINT bytesRead = 0U;
    if(f_read(&fileObject, fileBytesBuffer, 8, &bytesRead) != FR_OK
        || bytesRead != 8) {
        printf("SD file read [%d] FAILED\r\n", bytesRead);
        event.data[1] = TestResult_Failed;
        osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
        SCB_EnableDCache();
        osThreadExit();
    }

    printf("SD file content \"%s\".\r\n", fileBytesBuffer);

    if(strncmp((char*)fileBytesBuffer, "testfile", 8) != 0) {
        printf("SD file content FAILED.\r\n");
        event.data[1] = TestResult_Failed;
        osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
        SCB_EnableDCache();
        osThreadExit();
    }

    f_close(&fileObject);

    osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);

    SCB_EnableDCache();

    osThreadExit();

    while(1) {
        osDelay(1000);
    }
}
