/*
 * guiTask.h
 *
 *  Created on: Jan 29, 2025
 *      Author: krzysiek
 */

#ifndef GUITASK_H_
#define GUITASK_H_

#include "main.h"
#include "cmsis_os.h"

typedef enum {
    GuiEventType_Test = 0,
    GuiEventType_Button = 1,
    GuiEventType_Camera = 2,
    GuiEventType_Usb = 3,
    GuiEventType_Rs485 = 4,
    GuiEventType_Can = 5,
    GuiEventType_Eth = 6,
} GuiEventType_t;

typedef struct {
    GuiEventType_t type;
    uint32_t data[4];
} GuiEvent_t;

extern osThreadId_t guiTaskHandle;
extern const osThreadAttr_t guiTask_attributes;
extern osMessageQueueId_t guiEventQueueHandle;
extern const osMessageQueueAttr_t guiEventQueue_attributes;

void guiTask(void *argument);

#endif /* GUITASK_H_ */
