/*
 * test.h
 *
 *  Created on: Jan 29, 2025
 *      Author: krzysiek
 */

#ifndef INC_TEST_H_
#define INC_TEST_H_

/*
 * test.h
 *
 *  Created on: Jan 29, 2024
 *      Author: krzysiek
 */

typedef enum {
    TestType_Button    = 0x00,
    TestType_Eth       = 0x01,
    TestType_Sdram     = 0x02,
    TestType_Usb1      = 0x03,
    TestType_Usb2      = 0x04,
    TestType_Sd        = 0x05,
    TestType_Rs485     = 0x06,
    TestType_Can       = 0x07,
    TestType_Gpio      = 0x08,
    TestType_Bluetooth = 0x09,
    TestType_Wifi      = 0x0A,
    TestType_TestsCnt  = 0x0B,
} TestType_t;

typedef enum {
    TestResult_OK,
    TestResult_Failed,
    TestResult_InProgress,
    TestResult_NotAvailable,
} TestResult_t;

static inline char* getTestResultStr(TestResult_t result) {
    switch(result) {
    case TestResult_OK:
        return "OK";
    case TestResult_InProgress:
        return "IN PROGRESS";
    case TestResult_NotAvailable:
         return "N/A";
    default:
        return "FAILED";
    }
}

static inline char* getTestTypeStr(TestType_t type) {
    switch(type) {
    case TestType_Button:
        return "BUTTON......";
    case TestType_Eth:
        return "ETH.........";
    case TestType_Sdram:
        return "SDRAM.......";
    case TestType_Usb1:
        return "USB1........";
    case TestType_Usb2:
        return "USB2........";
    case TestType_Sd:
        return "SD..........";
    case TestType_Rs485:
        return "RS485.......";
    case TestType_Can:
        return "CAN.........";
    case TestType_Gpio:
        return "GPIO........";
    case TestType_Bluetooth:
        return "Bluetooth...";
    case TestType_Wifi:
        return "WIFI........";
    default:
        return "UNKNOWN.....";
    }
}

#endif /* INC_TEST_H_ */
