/*
 * ledTask.h
 *
 *  Created on: Jan 27, 2025
 *      Author: krzysiek
 */

#ifndef TASKS_LEDTASK_H_
#define TASKS_LEDTASK_H_

#include "main.h"
#include "cmsis_os.h"

typedef enum {
    LedState_Blink = 0,
    LedState_On    = 1,
    LedState_Off   = 2,
} LedState_t;

typedef struct {
    uint8_t ledId;
    LedState_t ledState;
} LedEvent_t;

extern osThreadId_t ledTaskHandle;
extern const osThreadAttr_t ledTask_attributes;
extern osMessageQueueId_t ledQueueHandle;
extern const osMessageQueueAttr_t ledQueue_attributes;

void ledTask(void *argument);

#endif /* TASKS_LEDTASK_H_ */
