/*
 * ledTask.c
 *
 *  Created on: Jan 27, 2025
 *      Author: krzysiek
 */

#include "ledTask.h"
#include "test.h"

#define LEDS_COUNT 5

osThreadId_t ledTaskHandle;

const osThreadAttr_t ledTask_attributes = {
  .name = "ledTask",
  .stack_size = configMINIMAL_STACK_SIZE * 4,
  .priority = (osPriority_t) osPriorityLow,
};

osMessageQueueId_t ledQueueHandle;
const osMessageQueueAttr_t ledQueue_attributes = {
  .name = "ledQueue"
};

static void setLedState(uint8_t ledId, uint8_t enabled) {
    switch(ledId) {
    case 0:
        HAL_GPIO_WritePin(LED_YELLOW_GPIO_Port, LED_YELLOW_Pin, !enabled);
        break;
    case 1:
        HAL_GPIO_WritePin(LED_RED_GPIO_Port, LED_RED_Pin, !enabled);
        break;
    case 2:
        HAL_GPIO_WritePin(LED_GREEN_GPIO_Port, LED_GREEN_Pin, !enabled);
        break;
    case 3:
        HAL_GPIO_WritePin(LED_AMBER_GPIO_Port, LED_AMBER_Pin, !enabled);
        break;
    case 4:
        HAL_GPIO_WritePin(LED_SYS_GPIO_Port, LED_SYS_Pin, !enabled);
        break;
    }
}

void ledTask(void *argument)
{
  while(1) {
      LedEvent_t event;
      if(osMessageQueueGet(ledQueueHandle, &event, NULL, 0) == osOK) {
          if(event.ledState == LedState_On) {
              setLedState(event.ledId, 1);
          } else if(event.ledState == LedState_Off) {
              setLedState(event.ledId, 0);
          }
      }
  }
}

