/*
 * guiTask.c
 *
 *  Created on: Jan 29, 2025
 *      Author: krzysiek
 */

#include "gui.h"
#include "guiTask.h"
#include "cameraTask.h"
#include "lvgl/lvgl.h"
#include "lvgl_port_touch.h"
#include "lvgl_port_display.h"
#include "test.h"

osThreadId_t guiTaskHandle;
const osThreadAttr_t guiTask_attributes = {
  .name = "guiTask",
  .stack_size = 2560 * 4,
  .priority = (osPriority_t) osPriorityNormal,
};

osMessageQueueId_t guiEventQueueHandle;
const osMessageQueueAttr_t guiEventQueue_attributes = {
  .name = "guiEventQueue"
};


void guiTask(void *argument) {

    lv_init();
    lvgl_display_init();
    lvgl_touchscreen_init();

    lv_theme_default_init(NULL,lv_palette_main(LV_PALETTE_GREEN), lv_palette_main(LV_PALETTE_NONE), false, LV_FONT_DEFAULT);

    guiInit();

    lvgl_display_backlight_enable(1);
    lvgl_display_brightness_enable(1);

    cameraTaskHandle = osThreadNew(cameraTask, NULL, &cameraTask_attributes);

    while(1) {
        uint32_t callAgainAfterMs = lv_task_handler();
        vTaskDelay(callAgainAfterMs / portTICK_PERIOD_MS);
        lv_tick_inc(callAgainAfterMs);

        GuiEvent_t event;
        if(osMessageQueueGet(guiEventQueueHandle, &event, NULL, 0) == osOK) {
            switch(event.type) {
            case GuiEventType_Button:
                guiSetLedState(event.data[0], event.data[1]);
                break;
            case GuiEventType_Camera:
                guiUpdateCameraImage();
                break;
            default:
                break;
            }
        }
    }
}
