/*
 * buttonTask.c
 *
 *  Created on: Jan 30, 2025
 *      Author: krzysiek
 */

#include "buttonTask.h"

#include "test.h"
#include "guiTask.h"

#define BUTTONS_CNT 4

osThreadId_t buttonTaskHandle;

const osThreadAttr_t buttonTask_attributes = {
  .name = "buttonTask",
  .stack_size = configMINIMAL_STACK_SIZE * 4,
  .priority = (osPriority_t) osPriorityLow,
};

void buttonTask(void *pvParameters) {

    uint32_t buttonValue[BUTTONS_CNT];

    buttonValue[0] = HAL_GPIO_ReadPin(BUTTON_H5_GPIO_Port, BUTTON_H5_Pin);
    buttonValue[1] = HAL_GPIO_ReadPin(BUTTON_H4_GPIO_Port, BUTTON_H4_Pin);
    buttonValue[2] = HAL_GPIO_ReadPin(BUTTON_H3_GPIO_Port, BUTTON_H3_Pin);
    buttonValue[3] = HAL_GPIO_ReadPin(BUTTON_H2_GPIO_Port, BUTTON_H2_Pin);

    while(1) {

        uint32_t buttonNewValue[BUTTONS_CNT];
        osDelay(50);

        buttonNewValue[0] = HAL_GPIO_ReadPin(BUTTON_H5_GPIO_Port, BUTTON_H5_Pin);
        buttonNewValue[1] = HAL_GPIO_ReadPin(BUTTON_H4_GPIO_Port, BUTTON_H4_Pin);
        buttonNewValue[2] = HAL_GPIO_ReadPin(BUTTON_H3_GPIO_Port, BUTTON_H3_Pin);
        buttonNewValue[3] = HAL_GPIO_ReadPin(BUTTON_H2_GPIO_Port, BUTTON_H2_Pin);

        for(int i = 0; i < BUTTONS_CNT; i++) {
            if(buttonValue[i] != buttonNewValue[i]) {
                buttonValue[i] = buttonNewValue[i];

                GuiEvent_t event;
                event.type = GuiEventType_Button;
                event.data[0] = i;
                event.data[1] = (buttonNewValue[i] == 0);
                osMessageQueuePut(guiEventQueueHandle, &event, 0, 0);
            }
        }
    }
}
