/*
 * gui.h
 *
 *  Created on: Jan 29, 2025
 *      Author: krzysiek
 */

#ifndef INC_GUI_H_
#define INC_GUI_H_

#include <stdint.h>
#include "test.h"

#define IMAGE_BUFFER_WIDTH 480
#define IMAGE_BUFFER_HEIGHT 272
#define IMAGE_BUFFER_BPP 2

extern uint8_t imageBuffer[IMAGE_BUFFER_HEIGHT * IMAGE_BUFFER_WIDTH * 2];

void guiInit(void);
void guiSetTestTableResult(TestType_t type, TestResult_t result);
void guiSetLedState(uint8_t id, uint8_t state);
void guiUpdateCameraImage(void);
void guiSetUsbLabel(uint8_t usbId, uint8_t attached, uint32_t vid, uint32_t pid);
void guiUpdateRs485Ping(uint8_t state);
void guiUpdateCanPing(uint8_t state);
void guiUpdateEthPing(uint8_t state, uint8_t ms);

#endif /* INC_GUI_H_ */
